/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONParticle;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.AModelParser;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.ConfigSystem;

public class EntityParticle
extends AEntityC_Renderable {
    private static final RenderableVertices STANDARD_PARTICLE_SPRITE = RenderableVertices.createSprite(1, null, null);
    private static final TransformationMatrix helperTransform = new TransformationMatrix();
    private static final RotationMatrix helperRotation = new RotationMatrix();
    private static final Point3D helperPoint = new Point3D();
    private static final ColorRGB helperColor = new ColorRGB();
    private static final Map<String, RenderableVertices> parsedParticleModels = new HashMap<String, RenderableVertices>();
    private static final Random particleRandom = new Random();
    private final AEntityC_Renderable entitySpawning;
    private final AnimationSwitchbox spawningSwitchbox;
    private final JSONParticle definition;
    private final int maxAge;
    private final Point3D initialVelocity;
    private final IWrapperPlayer clientPlayer = InterfaceManager.clientInterface.getClientPlayer();
    private ColorRGB startColor;
    private ColorRGB endColor;
    private final ColorRGB staticColor;
    private final String model;
    private final RenderableData renderable;
    private final boolean killBadParticle;
    private boolean touchingBlocks;
    private float timeOfNextTexture;
    private int textureIndex;
    private int textureDelayIndex;
    private List<String> textureList;
    private int timeOfCurrentColor;
    private int timeOfNextColor;
    private int colorIndex;
    private int colorDelayIndex;

    public EntityParticle(AEntityC_Renderable entitySpawning, JSONParticle definition, Point3D spawningPosition, Point3D spawningAngles, AnimationSwitchbox spawningSwitchbox) {
        super(entitySpawning.world, spawningPosition, ZERO_FOR_CONSTRUCTOR, spawningAngles != null ? spawningAngles : ZERO_FOR_CONSTRUCTOR);
        String texture;
        this.entitySpawning = entitySpawning;
        this.definition = definition;
        this.spawningSwitchbox = spawningSwitchbox;
        this.maxAge = this.generateMaxAge();
        this.boundingBox.heightRadius = this.boundingBox.widthRadius = (double)definition.hitboxSize / 2.0;
        this.boundingBox.depthRadius = this.boundingBox.widthRadius;
        helperTransform.resetTransforms();
        switch (definition.spawningOrientation) {
            case ENTITY: 
            case ATTACHED: {
                this.orientation.set(entitySpawning.orientation);
                helperTransform.set(entitySpawning.orientation);
                break;
            }
            case STREAK: 
            case WORLD_ATTACHED: {
                helperTransform.set(entitySpawning.orientation);
                break;
            }
            case FACING: {
                if (!(entitySpawning instanceof EntityBullet)) break;
                EntityBullet bullet = (EntityBullet)entitySpawning;
                if (bullet.sideHit != ABlockBase.Axis.NONE) {
                    helperRotation.setToZero().rotateX(-90.0);
                    this.orientation.set(bullet.sideHit.facingRotation).multiplyTranspose(helperRotation);
                    helperTransform.set(this.orientation);
                    break;
                }
                this.initialVelocity = null;
                this.staticColor = null;
                this.renderable = null;
                this.model = null;
                this.killBadParticle = true;
                return;
            }
        }
        if (definition.distance == 0.0f) {
            EntityParticle.setPointToSpawn(spawningPosition, null, definition.pos, entitySpawning.scale, spawningSwitchbox, this.position);
        } else {
            this.position.set(spawningPosition);
        }
        this.prevPosition.set(this.position);
        Point3D blockCheckPosition = definition.getBlockPropertiesFromGround ? this.position.copy().add(0.0, -this.world.getHeight(this.position) - 0.5, 0.0) : spawningPosition;
        if (definition.type == JSONParticle.ParticleType.BREAK && this.world.isAir(blockCheckPosition)) {
            this.staticColor = null;
            this.renderable = null;
            this.model = null;
            this.initialVelocity = null;
            this.killBadParticle = true;
            return;
        }
        this.setOrientationToSpawn();
        this.prevOrientation.set(this.orientation);
        if (definition.initialVelocity != null) {
            if (definition.spreadRandomness != null) {
                this.motion.x = 2.0 * definition.spreadRandomness.x * Math.random() - definition.spreadRandomness.x;
                this.motion.y = 2.0 * definition.spreadRandomness.y * Math.random() - definition.spreadRandomness.y;
                this.motion.z = 2.0 * definition.spreadRandomness.z * Math.random() - definition.spreadRandomness.z;
                this.motion.add(definition.initialVelocity);
            } else {
                this.motion.x = definition.initialVelocity.x + 0.2 - Math.random() * 0.4;
                this.motion.y = definition.initialVelocity.y + 0.2 - Math.random() * 0.4;
                this.motion.z = definition.initialVelocity.z + 0.2 - Math.random() * 0.4;
            }
            this.motion.scale(0.1);
            this.motion.rotate(helperTransform);
        }
        if (definition.relativeInheritedVelocityFactor != null) {
            helperPoint.set(entitySpawning.motion);
            if (entitySpawning instanceof EntityVehicleF_Physics) {
                helperPoint.scale(((EntityVehicleF_Physics)entitySpawning).speedFactor);
            } else if (entitySpawning instanceof APart) {
                APart partSpawning = (APart)entitySpawning;
                if (partSpawning.vehicleOn != null) {
                    helperPoint.scale(partSpawning.vehicleOn.speedFactor);
                }
            }
            helperRotation.setToVector(entitySpawning.motion, true);
            helperPoint.reOrigin(helperRotation).multiply(definition.relativeInheritedVelocityFactor).rotate(helperRotation);
            this.motion.add(helperPoint);
        }
        this.initialVelocity = this.motion.copy();
        this.updateOrientation();
        String model = definition.model;
        if (definition.texture != null) {
            texture = definition.texture;
        } else if (definition.type == JSONParticle.ParticleType.BREAK) {
            texture = "GLOBAL";
        } else if (definition.type == JSONParticle.ParticleType.CASING) {
            PartGun gun = (PartGun)entitySpawning;
            if (!gun.firedBullets.isEmpty()) {
                ItemBullet bullet = gun.firedBullets.get(0);
                gun.firedBullets.remove(0);
                texture = ((JSONBullet)bullet.definition).bullet.casingTexture;
                model = ((JSONBullet)bullet.definition).bullet.casingModel;
            } else {
                texture = null;
                model = null;
            }
            if (texture == null) {
                this.staticColor = null;
                this.renderable = null;
                this.model = null;
                this.killBadParticle = true;
                return;
            }
        } else if (definition.type == JSONParticle.ParticleType.SMOKE) {
            this.textureList = new ArrayList<String>();
            for (int i = 0; i <= 11; ++i) {
                this.textureList.add("mts:textures/particles/big_smoke_" + i + ".png");
            }
            texture = this.textureList.get(0);
            this.timeOfNextTexture = (int)((float)this.maxAge / 12.0f);
        } else if (definition.textureList != null) {
            this.textureList = definition.textureList;
            if (definition.randomTexture) {
                this.textureIndex = particleRandom.nextInt(this.textureList.size());
            }
            texture = this.textureList.get(this.textureIndex);
            this.timeOfNextTexture = definition.textureDelays != null ? (float)definition.textureDelays.get(this.textureDelayIndex).intValue() : (float)this.maxAge;
        } else if (definition.type == JSONParticle.ParticleType.SMOKE) {
            this.textureList = new ArrayList<String>();
            for (int i = 0; i <= 11; ++i) {
                this.textureList.add("mts:textures/particles/big_smoke_" + i + ".png");
            }
            texture = this.textureList.get(0);
            this.timeOfNextTexture = (float)this.maxAge / 12.0f;
        } else {
            texture = "mts:textures/particles/" + definition.type.name().toLowerCase(Locale.ROOT) + ".png";
        }
        this.model = model;
        if (this.model != null) {
            RenderableVertices parsedModel = parsedParticleModels.computeIfAbsent(this.model, k -> {
                String modelDomain = this.model.substring(0, this.model.indexOf(58));
                String modelPath = this.model.substring(modelDomain.length() + 1);
                List<RenderableVertices> parsedObjects = AModelParser.parseModel("/assets/" + modelDomain + "/" + modelPath, true);
                int totalVertices = 0;
                for (RenderableVertices parsedObject : parsedObjects) {
                    totalVertices += parsedObject.vertices.capacity();
                }
                FloatBuffer totalBuffer = FloatBuffer.allocate(totalVertices);
                for (RenderableVertices parsedObject : parsedObjects) {
                    totalBuffer.put(parsedObject.vertices);
                }
                totalBuffer.flip();
                return new RenderableVertices("PARTICLE_3D", totalBuffer, false);
            });
            this.renderable = new RenderableData(parsedModel, texture);
        } else if (definition.type == JSONParticle.ParticleType.BREAK) {
            RenderableVertices vertexObject = RenderableVertices.createSprite(1, null, null);
            this.renderable = new RenderableData(vertexObject, texture);
            float[] uvPoints = InterfaceManager.renderingInterface.getBlockBreakTexture(this.world, blockCheckPosition);
            vertexObject.setTextureBounds(uvPoints[0], uvPoints[1], uvPoints[2], uvPoints[3]);
        } else {
            this.renderable = new RenderableData(STANDARD_PARTICLE_SPRITE, "GLOBAL");
        }
        this.renderable.setTexture(texture);
        if (definition.useBlockColor) {
            this.staticColor = this.world.getBlockColor(blockCheckPosition);
        } else if (definition.color != null) {
            if (definition.toColor != null) {
                this.startColor = definition.color;
                this.endColor = definition.toColor;
                this.timeOfNextColor = this.maxAge;
                this.staticColor = null;
            } else {
                this.staticColor = definition.color;
            }
        } else if (definition.colorList != null) {
            if (definition.randomColor) {
                this.colorIndex = particleRandom.nextInt(definition.colorList.size());
            }
            this.startColor = definition.colorList.get(this.colorIndex);
            this.endColor = this.colorIndex + 1 < definition.colorList.size() ? definition.colorList.get(this.colorIndex + 1) : definition.colorList.get(0);
            this.timeOfNextColor = definition.colorDelays != null ? definition.colorDelays.get(this.colorDelayIndex) : this.maxAge;
            this.staticColor = null;
        } else {
            this.staticColor = ColorRGB.WHITE;
        }
        if (this.staticColor != null) {
            this.renderable.setColor(this.staticColor);
        }
        if (definition.transparency != 0.0f || definition.toTransparency != 0.0f) {
            this.renderable.setAlpha(definition.transparency);
        }
        if (definition.type.equals((Object)JSONParticle.ParticleType.FLAME) || definition.isBright) {
            this.renderable.setLightMode(RenderableData.LightingMode.IGNORE_ALL_LIGHTING);
            if (((Boolean)ConfigSystem.client.renderingSettings.lightsTransp.value).booleanValue()) {
                this.renderable.setTransucentOverride();
            }
        } else if (model == null) {
            this.renderable.setLightMode(RenderableData.LightingMode.IGNORE_ORIENTATION_LIGHTING);
        }
        if (definition.isBlended) {
            this.renderable.setBlending((Boolean)ConfigSystem.client.renderingSettings.blendedLights.value);
        }
        this.killBadParticle = false;
    }

    public static void setPointToSpawn(Point3D origin, RotationMatrix orientation, Point3D definitionOffset, Point3D scale, AnimationSwitchbox spawningSwitchbox, Point3D pointToSet) {
        if (definitionOffset != null) {
            helperPoint.set(definitionOffset).multiply(scale);
        } else {
            helperPoint.set(0.0, 0.0, 0.0);
        }
        if (orientation != null) {
            helperTransform.resetTransforms();
            helperTransform.set(orientation);
        }
        if (spawningSwitchbox != null) {
            spawningSwitchbox.runSwitchbox(0.0f, false);
            helperTransform.multiply(spawningSwitchbox.netMatrix);
        }
        helperPoint.transform(helperTransform);
        pointToSet.set(origin).add(helperPoint);
    }

    private void setOrientationToSpawn() {
        if (this.definition.rot != null) {
            this.orientation.multiply(this.definition.rot);
        }
        if (this.definition.rotationRandomness != null) {
            helperPoint.set(this.definition.rotationRandomness);
            EntityParticle.helperPoint.x = (2.0 * Math.random() - 1.0) * EntityParticle.helperPoint.x;
            EntityParticle.helperPoint.y = (2.0 * Math.random() - 1.0) * EntityParticle.helperPoint.y;
            EntityParticle.helperPoint.z = (2.0 * Math.random() - 1.0) * EntityParticle.helperPoint.z;
            helperRotation.setToAngles(helperPoint);
            this.orientation.multiply(helperRotation);
        }
    }

    @Override
    public AEntityA_Base.EntityAutoUpdateTime getUpdateTime() {
        if (this.entitySpawning instanceof APart) {
            return ((APart)this.entitySpawning).masterEntity.getUpdateTime();
        }
        return this.entitySpawning.getUpdateTime();
    }

    @Override
    public void update() {
        super.update();
        if (this.ticksExisted == (long)this.maxAge || this.killBadParticle) {
            this.remove();
            return;
        }
        if (!this.definition.stopsOnGround || !this.touchingBlocks) {
            if (this.definition.spawningOrientation == JSONParticle.ParticleSpawningOrientation.ATTACHED) {
                this.orientation.set(this.entitySpawning.orientation);
                helperTransform.resetTransforms();
                helperTransform.set(this.orientation);
                EntityParticle.setPointToSpawn(this.entitySpawning.position, null, this.definition.pos, this.entitySpawning.scale, this.spawningSwitchbox, this.position);
                this.setOrientationToSpawn();
            } else if (this.definition.spawningOrientation == JSONParticle.ParticleSpawningOrientation.WORLD_ATTACHED) {
                helperTransform.resetTransforms();
                helperTransform.set(this.entitySpawning.orientation);
                EntityParticle.setPointToSpawn(this.entitySpawning.position, null, this.definition.pos, this.entitySpawning.scale, this.spawningSwitchbox, this.position);
            }
            if (this.definition.movementDuration != 0 && this.ticksExisted <= (long)this.definition.movementDuration) {
                float durationFactor = (float)((long)this.definition.movementDuration - this.ticksExisted) / (float)this.definition.movementDuration;
                double absX = Math.abs(this.initialVelocity.x * (double)durationFactor);
                double absY = Math.abs(this.initialVelocity.y * (double)durationFactor);
                double absZ = Math.abs(this.initialVelocity.z * (double)durationFactor);
                if (Math.abs(this.motion.x) > absX) {
                    this.motion.x = Math.signum(this.motion.x) * absX;
                }
                if (Math.abs(this.motion.y) > absY) {
                    this.motion.y = Math.signum(this.motion.y) * absY;
                }
                if (Math.abs(this.motion.z) > absZ) {
                    this.motion.z = Math.signum(this.motion.z) * absZ;
                }
            }
            if (this.definition.movementVelocity != null) {
                this.motion.add(this.definition.movementVelocity);
            }
            if (this.definition.relativeMovementVelocity != null) {
                helperRotation.setToVector(this.motion, true);
                helperPoint.set(this.definition.relativeMovementVelocity).rotate(helperRotation);
                this.motion.add(helperPoint);
            }
            if (this.definition.movementVelocity == null && this.definition.relativeMovementVelocity == null) {
                switch (this.definition.type) {
                    case SMOKE: {
                        this.motion.x *= 0.9;
                        this.motion.y += 0.004;
                        this.motion.z *= 0.9;
                        break;
                    }
                    case FLAME: {
                        this.motion.scale(0.96);
                        break;
                    }
                    case BUBBLE: {
                        if (!this.world.isBlockLiquid(this.position)) {
                            this.remove();
                            break;
                        }
                        this.motion.scale(0.85).add(0.0, 0.002, 0.0);
                        break;
                    }
                    case BREAK: {
                        if (!this.touchingBlocks) {
                            this.motion.scale(0.98).add(0.0, -0.04, 0.0);
                            break;
                        }
                        this.motion.scale(0.0);
                        break;
                    }
                }
            }
            if (this.definition.terminalVelocity != null) {
                if (this.motion.x > this.definition.terminalVelocity.x) {
                    this.motion.x = this.definition.terminalVelocity.x;
                }
                if (this.motion.x < -this.definition.terminalVelocity.x) {
                    this.motion.x = -this.definition.terminalVelocity.x;
                }
                if (this.motion.y > this.definition.terminalVelocity.y) {
                    this.motion.y = this.definition.terminalVelocity.y;
                }
                if (this.motion.y < -this.definition.terminalVelocity.y) {
                    this.motion.y = -this.definition.terminalVelocity.y;
                }
                if (this.motion.z > this.definition.terminalVelocity.z) {
                    this.motion.z = this.definition.terminalVelocity.z;
                }
                if (this.motion.z < -this.definition.terminalVelocity.z) {
                    this.motion.z = -this.definition.terminalVelocity.z;
                }
            }
            if (!this.definition.ignoreCollision) {
                this.touchingBlocks = this.boundingBox.updateCollisions(this.world, this.motion, true);
                if (this.touchingBlocks) {
                    double distance;
                    this.motion.subtract(this.boundingBox.currentCollisionDepth);
                    if (this.definition.stopsOnGround && this.definition.groundSounds != null && (distance = this.position.distanceTo(this.clientPlayer.getPosition())) < 32.0) {
                        SoundInstance sound = new SoundInstance((AEntityB_Existing)this, this.definition.groundSounds.get(particleRandom.nextInt(this.definition.groundSounds.size())));
                        sound.volume = (float)(1.0 - distance / 32.0);
                        InterfaceManager.soundInterface.playQuickSound(sound);
                    }
                }
            }
            this.position.add(this.motion);
            this.updateOrientation();
            if (this.definition.rotationVelocity != null) {
                helperRotation.setToAngles(this.definition.rotationVelocity);
                this.orientation.multiply(helperRotation);
            }
        }
        if (this.textureList != null && this.timeOfNextTexture <= (float)this.ticksExisted) {
            if (++this.textureIndex == this.textureList.size()) {
                this.textureIndex = 0;
            }
            this.renderable.texture = this.textureList.get(this.textureIndex);
            if (this.definition.textureDelays != null) {
                if (++this.textureDelayIndex == this.definition.textureDelays.size()) {
                    this.textureDelayIndex = 0;
                }
                this.timeOfNextTexture += (float)this.definition.textureDelays.get(this.textureDelayIndex).intValue();
            } else {
                this.timeOfNextTexture += (float)this.maxAge / 12.0f;
            }
        }
        if (this.definition.colorDelays != null && (long)this.timeOfNextColor == this.ticksExisted) {
            if (++this.colorIndex == this.definition.colorList.size()) {
                this.colorIndex = 0;
            }
            this.startColor = this.definition.colorList.get(this.colorIndex);
            this.endColor = this.colorIndex + 1 < this.definition.colorList.size() ? this.definition.colorList.get(this.colorIndex + 1) : this.definition.colorList.get(0);
            if (++this.colorDelayIndex == this.definition.colorDelays.size()) {
                this.colorDelayIndex = 0;
            }
            this.timeOfCurrentColor = this.timeOfNextColor;
            this.timeOfNextColor += this.definition.colorDelays.get(this.colorDelayIndex).intValue();
        }
        if (this.definition.subParticles != null) {
            for (JSONParticle.JSONSubParticle subDef : this.definition.subParticles) {
                if (!(subDef.particle.spawnEveryTick ? (long)subDef.time >= this.ticksExisted : (long)subDef.time == this.ticksExisted)) continue;
                this.world.addEntity(new EntityParticle(this, subDef.particle, this.position, null, null));
            }
        }
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return true;
    }

    @Override
    public boolean shouldSync() {
        return false;
    }

    @Override
    public boolean shouldSavePosition() {
        return false;
    }

    @Override
    protected void renderModel(TransformationMatrix transform, boolean blendingEnabled, float partialTicks) {
        if (this.definition.toTransparency != 0.0f) {
            this.renderable.setAlpha(this.interpolate(this.definition.transparency, this.definition.toTransparency, ((float)this.ticksExisted + partialTicks) / (float)this.maxAge, true, partialTicks));
        } else {
            this.renderable.setAlpha(this.definition.transparency != 0.0f ? this.definition.transparency : 1.0f);
        }
        if ((long)this.definition.fadeInTransparencyTime >= this.ticksExisted) {
            this.renderable.setAlpha(this.renderable.alpha * (float)this.ticksExisted / (float)this.definition.fadeInTransparencyTime);
        }
        if ((long)this.definition.fadeOutTransparencyTime > (long)this.maxAge - this.ticksExisted) {
            this.renderable.setAlpha(this.renderable.alpha * (float)((long)this.maxAge - this.ticksExisted) / (float)this.definition.fadeOutTransparencyTime);
        }
        if (this.definition.daytimeReductionFactor != 0.0f) {
            this.renderable.setAlpha(this.renderable.alpha * (1.0f - this.definition.daytimeReductionFactor * this.world.getLightBrightness(this.position, true)));
        }
        if (this.renderable.isTranslucent == blendingEnabled) {
            if (this.staticColor == null) {
                float colorDelta = ((float)this.ticksExisted + partialTicks - (float)this.timeOfCurrentColor) / (float)(this.timeOfNextColor - this.timeOfCurrentColor);
                EntityParticle.helperColor.red = this.interpolate(this.startColor.red, this.endColor.red, colorDelta, true, partialTicks);
                EntityParticle.helperColor.green = this.interpolate(this.startColor.green, this.endColor.green, colorDelta, true, partialTicks);
                EntityParticle.helperColor.blue = this.interpolate(this.startColor.blue, this.endColor.blue, colorDelta, true, partialTicks);
                this.renderable.setColor(helperColor);
            }
            this.renderable.transform.set(transform);
            double totalScale = this.definition.type == JSONParticle.ParticleType.FLAME && this.definition.scale == 0.0f && this.definition.toScale == 0.0f ? 1.0 - Math.pow(((float)this.ticksExisted + partialTicks) / (float)this.maxAge, 2.0) / 2.0 : (this.definition.toScale != 0.0f ? (double)this.interpolate(this.definition.scale, this.definition.toScale, ((float)this.ticksExisted + partialTicks) / (float)this.maxAge, false, partialTicks) : (this.definition.scale != 0.0f ? (double)this.definition.scale : 1.0));
            if ((long)this.definition.fadeInScaleTime >= this.ticksExisted) {
                totalScale *= (double)(1.0f - (float)((long)this.definition.fadeInScaleTime - this.ticksExisted) / (float)this.definition.fadeInScaleTime);
            }
            if ((long)this.definition.fadeOutScaleTime > (long)this.maxAge - this.ticksExisted) {
                totalScale *= (double)((float)((long)this.maxAge - this.ticksExisted) / (float)this.definition.fadeOutScaleTime);
            }
            this.renderable.transform.applyScaling(totalScale * this.entitySpawning.scale.x, totalScale * this.entitySpawning.scale.y, totalScale * this.entitySpawning.scale.z);
            this.renderable.setLightValue(this.worldLightValue);
            this.renderable.render();
        }
    }

    @Override
    public boolean disableRendering() {
        return this.killBadParticle || super.disableRendering();
    }

    private void updateOrientation() {
        switch (this.definition.renderingOrientation) {
            case FIXED: {
                break;
            }
            case PLAYER: {
                helperPoint.set(InterfaceManager.clientInterface.getCameraPosition()).subtract(this.position);
                this.orientation.setToVector(helperPoint, true);
                break;
            }
            case YAXIS: {
                helperPoint.set(InterfaceManager.clientInterface.getCameraPosition()).subtract(this.position);
                EntityParticle.helperPoint.y = 0.0;
                this.orientation.setToVector(helperPoint, true);
                break;
            }
            case MOTION: {
                this.orientation.setToVector(this.motion, true);
            }
        }
    }

    private int generateMaxAge() {
        if (this.definition.duration != 0) {
            if (this.definition.durationRandomness != 0) {
                return this.definition.duration + (int)((float)(this.definition.durationRandomness * 2) * particleRandom.nextFloat() - (float)this.definition.durationRandomness);
            }
            return this.definition.duration;
        }
        switch (this.definition.type) {
            case SMOKE: {
                return 33;
            }
            case FLAME: 
            case BUBBLE: {
                return (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
            }
            case BREAK: {
                return (int)(4.0 / (Math.random() * 0.9 + 0.1));
            }
        }
        return (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    private float interpolate(float start, float end, float factor, boolean clamp, float partialTicks) {
        float value = start + (end - start) * factor;
        return clamp ? (value > 1.0f ? 1.0f : (value < 0.0f ? 0.0f : value)) : value;
    }
}

